%========================================================================================%
%============================= General setup for BVARs ==================================%
%========================================================================================%
RESTART_AS_NEWPROGRAM = 1;
if (RESTART_AS_NEWPROGRAM)
clear all;
close all;
clc;
end
%addpath('/Users/Tong/Dropbox/Projects/MSBVAR/TaoCode/MatlabFiles');
%addpath('/Users/Tong/Dropbox/projects/MSBVAR/CodeTX/MatlabFilesAddTX/');
format short g  % format

%%  ******* The period of the available raw data
q_m    = 4;      % 12: monthly data; 4: quarterly data
yrBin  = 1949;   % beginning year
qmBin  = 1;      % begining quarter or month
yrFin  = 2016;   % final year
qmFin  = 4;      % final quarter or month 
nData = (yrFin-yrBin)*q_m + (qmFin-qmBin+1); % total number of the available data -- this is all you have
qmdates4data = ((yrBin+(qmBin-1)/q_m):1/q_m:(yrFin+(qmFin-1)/q_m))';  % quarterly or monthly dates for the sample (including lags)
%[[1:nData]', qmdates4data];

%%  ******* Loading and manipulating raw data (the data MUST be expressed in log or in decimal point (i.e., already divided by 100))
load data201608_hz  % generated by DataRaw/GetData4Porject6.m 
%hz_data_q_struct.q_dates_data
if (length(hz_data_q_struct.q_dates_data) ~= nData)
  error(sprintf('The data length is %d, not equal to the intended length %d', length(hz_data_q_struct.q_dates_data),nData));      
end  
xdd = [
log(hz_data_q_struct.ForeignReserves.*hz_data_q_struct.ExchangeRate                ), ...    %  1 converted to RMBs
hz_data_q_struct.ERR2                                                               , ...    %  2 EOQ
hz_data_q_struct.ARR2                                                               , ...    %  3 EOQ
log(hz_data_q_struct.M2                                                            ), ...    %  4
log(hz_data_q_struct.M2TargetWZ3322_SA                                             ), ...    %  5 from 1999Q1 on
log(hz_data_q_struct.M2TargetWZEven_SA                                             ), ...    %  6 from 1999Q1 on 
hz_data_q_struct.LendingRatePBC1year                                                , ...    %  7
hz_data_q_struct.DepositRatePBC1year                                                , ...    %  8
log(hz_data_q_struct.BankLoansTotal         ./ hz_data_q_struct.GDPDeflator        ), ...    %  9
log(hz_data_q_struct.BankLoansST            ./ hz_data_q_struct.GDPDeflator        ), ...    % 10
log(hz_data_q_struct.BankLoansMLT           ./ hz_data_q_struct.GDPDeflator        ), ...    % 11
log(hz_data_q_struct.NominalRetailGoodsC    ./ hz_data_q_struct.GDPDeflator        ), ...    % 12
log(hz_data_q_struct.NominalLightFAI        ./ hz_data_q_struct.GDPDeflator        ), ...    % 13
log(hz_data_q_struct.NominalHeavyFAI        ./ hz_data_q_struct.GDPDeflator        ), ...    % 14 
log(hz_data_q_struct.NominalHHC             ./ hz_data_q_struct.GDPDeflator        ), ...    % 15
log(hz_data_q_struct.NominalHHGFCF          ./ hz_data_q_struct.GDPDeflator        ), ...    % 16
log(hz_data_q_struct.NominalGovtGFCF        ./ hz_data_q_struct.GDPDeflator        ), ...    % 17
log(hz_data_q_struct.NominalSOEGFCF         ./ hz_data_q_struct.GDPDeflator        ), ...    % 18
log(hz_data_q_struct.NominalPrivGFCF        ./ hz_data_q_struct.GDPDeflator        ), ...    % 19
log(hz_data_q_struct.NominalNetExports      ./ hz_data_q_struct.GDPDeflator        ), ...    % 20
log(hz_data_q_struct.NominalExportsGoods    ./ hz_data_q_struct.GDPDeflator        ), ...    % 21
log(hz_data_q_struct.NominalImportsGoods    ./ hz_data_q_struct.GDPDeflator        ), ...    % 22
log(hz_data_q_struct.NominalGDPva           ./ hz_data_q_struct.GDPDeflator        ), ...    % 23
log(hz_data_q_struct.NominalGDP             ./ hz_data_q_struct.GDPDeflator        ), ...    % 24
log(hz_data_q_struct.CPI                                                           ), ...    % 25
log(hz_data_q_struct.GDPDeflator                                                   ), ...    % 26 
log(hz_data_q_struct.Employment                                                    ), ...    % 27
log(hz_data_q_struct.NominalShadowLoans     ./ hz_data_q_struct.GDPDeflator        ), ...    % 28 from 2001Q4 on
log(hz_data_q_struct.ExchangeRate                                                  ), ...    % 29
hz_data_q_struct.R1dRepo                                                            , ...    % 30
log(hz_data_q_struct.NominalSOEexGovtGFCF   ./ hz_data_q_struct.GDPDeflator        ), ...    % 31
hz_data_q_struct.ratioNewLoansNFEST2GDP                                             , ...    % 32
hz_data_q_struct.ratioNewLoansNFESTBF2GDP                                           , ...    % 33
hz_data_q_struct.ratioNewLoansNFEMLT2GDP                                            , ...    % 34
hz_data_q_struct.ratioNewLoansNFEST2GDPva                                           , ...    % 35
hz_data_q_struct.ratioNewLoansNFESTBF2GDPva                                         , ...    % 36
hz_data_q_struct.ratioNewLoansNFEMLT2GDPva                                          , ...    % 37
log(hz_data_q_struct.NominalFAI             ./ hz_data_q_struct.GDPDeflator        ), ...    % 38 
log(hz_data_q_struct.Target3322M2_EOQ_SA                                           ), ...    % 39 from 1999Q1 on
log(hz_data_q_struct.TargetEvenM2_EOQ_SA                                           ), ...    % 40 from 1999Q1 on 
log(hz_data_q_struct.M2_EOQ                                                        ), ...    % 41
log(hz_data_q_struct.M2PBC                                                         ), ...    % 42
log(hz_data_q_struct.M2PBC_EOQ                                                     ), ...    % 43
log(hz_data_q_struct.NominalGDPva_X11                                              ), ...    % 44
log(hz_data_q_struct.RealGDPva_X11                                                 ), ...    % 45
log(hz_data_q_struct.GDPDeflator_X11                                               ), ...    % 46
hz_data_q_struct.R7dRepo                                                            , ...    % 47
hz_data_q_struct.R1dChibor                                                          , ...    % 48
hz_data_q_struct.R7dChibor                                                                   
];
%-
loc_CPI     = 25;
loc_M2      = 4;  %M2 is an average of quarterly, which must be used. 

%------------ Detrending log GDP ----------------
logGDPva = log(hz_data_q_struct.RealGDPva_X11); 
Xright = [ones(nData,1),[1:nData]'];
[ycoefs,ycoefsinv,yresids] = regress(logGDPva, Xright);
logGDPvaTrend = Xright*ycoefs;
%-
nbegoffsets = 172; %193--1997Q1; 172--1992Q1;
nendoffsets = 2;   %2--2016Q2; 3--2016Q1;
logGDPvaHP = hpfilter(logGDPva((nbegoffsets+1):(end-nendoffsets)), 1600);
logGDPvaHP = [NaN*ones(nbegoffsets,1); logGDPvaHP; NaN*ones(nendoffsets,1)];
%-
logGDPgapLLDTt_all   = logGDPva - logGDPvaTrend;  %LTDT: log linear detrended.
logGDPgapHPFt_all    = logGDPva - logGDPvaHP;     %HPDT: HP filtered.
logGDPgapLLDTtm1_all = [NaN; logGDPgapLLDTt_all(1:(end-1))];
logGDPgapHPFtm1_all  = [NaN; logGDPgapHPFt_all(1:(end-1))];

load data_GDPgapRaw  %GDPgapRaw generated by GetGDPGap.m in /Users/tzha/Dropbox/ZhaProjects/China/_MonetaryPolicy/_DataRaw/_FromKaijiKaren2
%1:  累计同比 
%2:  GDP targets
%3:  GDP gap w.r.t. 累计同比
%4:  同比 
%5:  GDP targets
%6:  GDP gap w.r.t. 同比 only
GDPgrowthTarget = GDPgapRaw(:,2)/100;  %GDP growth target
GDPloglevelTarget = NaN*ones(nData,1);
GDPloglevelTarget(5:end) = GDPgrowthTarget(5:end) + logGDPva(1:(end-4));  %GDP log level target  
%---
GDPGapcumt_all = GDPgapRaw(:,3)/100;
DummyNegativeGapcumt_all = zeros(nData,1);
DummyNegativeGapcumt_all(find(GDPGapcumt_all<0.0)) = 1.0;
GDPGapcumtm1_all = [NaN; GDPGapcumt_all(1:(end-1))];
DummyNegativeGapcumtm1_all = [NaN; DummyNegativeGapcumt_all(1:(end-1))];
%[qmdates4data, DummyNegativeGapcum]
GDPGapyoy_all = GDPgapRaw(:,6)/100;
DummyNegativeGapyoy_all = zeros(nData,1);
DummyNegativeGapyoy_all(find(GDPGapyoy_all<0.0)) = 1.0;

%------------ Construction key variables ----------------
logM2At     = log(hz_data_q_struct.M2);                                %log actual M2 at time t.
logM2Atm1   = [NaN; logM2At(1:(end-1))];                               %log actual M2 at time t-1.
logM2Atm2   = [NaN; NaN; logM2At(1:(end-2))];                          %log actual M2 at time t-2.
logGDPt     = logGDPva;                                                %log actual GDP at time t.
logGDPtm1   = [NaN; logGDPva(1:(end-1))];                              %log actual GDP at time t-1.
logGDPtm2   = [NaN; NaN; logGDPva(1:(end-2))];                         %log actual GDP at time t-2.
logCPIt     = log(hz_data_q_struct.CPI);                               %log actual CPI at time t.
logCPItm1   = [NaN; logCPIt(1:(end-1))];                               %log actual CPI at time t-1.
logCPItm2   = [NaN; NaN; logCPIt(1:(end-2))];                          %log actual CPI at time t-2.
logCPItm4   = [NaN; NaN; NaN; NaN; logCPIt(1:(end-4))];                %log actual CPI at time t-4.
GDPloglevelTarget_t     = [GDPloglevelTarget];                         %log GDP target at time t.
GDPloglevelTarget_tm1   = [NaN; GDPloglevelTarget(1:(end-1))];         %log GDP target at time t-1.
GDPloglevelTarget_tm2   = [NaN; NaN; GDPloglevelTarget(1:(end-2))];    %log GDP target at time t-2.
%-
M2gAt_qoq_all                   = logM2At - logM2Atm1;
M2gAtm1_qoq_all                 = logM2Atm1 - logM2Atm2;
CPIgtm1_qoq_all                 = logCPItm1 - logCPItm2;
GDPgtm1_qoq_all                 = logGDPtm1 - logGDPtm2;
GDPtargettm1_qoq_all            = GDPloglevelTarget_tm1 - logGDPtm2;
IndicatorGDPBelowTargettm1_all  = (GDPgtm1_qoq_all < GDPtargettm1_qoq_all);
CPIgt_qoq_all                   = logCPIt - logCPItm1;
GDPgt_qoq_all                   = logGDPt - logGDPtm1;
GDPtargett_qoq_all              = GDPloglevelTarget_t - logGDPtm1;


%%  ******* The specific sample range and related specifications
yrStart = 2000;
qmStart = 1;
yrEnd   = 2016;
qmEnd   = 2;
nSample = (yrEnd-yrStart)*q_m + (qmEnd-qmStart+1);  % sample length (including lags)
qmdates4sample = ((yrStart+(qmStart-1)/q_m):1/q_m:(yrEnd+(qmEnd-1)/q_m))';  % quarterly or monthly dates for the sample (including lags)
nStart=(yrStart-yrBin)*q_m+qmStart-qmBin;  % positive number of months at the start
nEnd=(yrEnd-yrFin)*q_m+qmEnd-qmFin;     % negative number of months towards end
if ((nEnd>0) | (nStart<0))
   error('The specified sample is out of the bounds of the data!');
end
M2gAt_qoq                       = M2gAt_qoq_all(        (nStart+1):(nData+nEnd));
M2gAtm1_qoq                     = M2gAtm1_qoq_all(      (nStart+1):(nData+nEnd));
CPIgtm1_qoq                     = CPIgtm1_qoq_all(      (nStart+1):(nData+nEnd));
GDPgtm1_qoq                     = GDPgtm1_qoq_all(      (nStart+1):(nData+nEnd));     
GDPtargettm1_qoq                = GDPtargettm1_qoq_all( (nStart+1):(nData+nEnd));
IndicatorGDPBelowTargettm1      = IndicatorGDPBelowTargettm1_all((nStart+1):(nData+nEnd));
CPIgt_qoq                       = CPIgt_qoq_all(        (nStart+1):(nData+nEnd));
GDPgt_qoq                       = GDPgt_qoq_all(        (nStart+1):(nData+nEnd));     
GDPtargett_qoq                  = GDPtargett_qoq_all(   (nStart+1):(nData+nEnd));

disp(' ');
disp('*************************** GDP log linear detrended ***************************');
logGDPgapLLDTtm1 = logGDPgapLLDTtm1_all((nStart+1):(nData+nEnd));     
regtblLLDT = table(M2gAtm1_qoq, CPIgtm1_qoq, logGDPgapLLDTtm1, M2gAt_qoq, 'VariableNames',{'LaggedM2g','CPIg','GDPgapLLDT','M2g'});
MPgapLLDT_results = fitlm(regtblLLDT,'M2g~LaggedM2g+CPIg+GDPgapLLDT')
%-
disp(' ');
disp('*************************** GDP HP detrended ***************************');
logGDPgapHPFtm1 = logGDPgapHPFtm1_all((nStart+1):(nData+nEnd));     
regtblHPF = table(M2gAtm1_qoq, CPIgtm1_qoq, logGDPgapHPFtm1, M2gAt_qoq, 'VariableNames',{'LaggedM2g','CPIg','GDPgapHPF','M2g'});
MPgapHPF_results = fitlm(regtblHPF,'M2g~LaggedM2g+CPIg+GDPgapHPF')
%-
disp(' ');
disp('*************************** GDP targeted ***************************');
logGDPgapTargetedtm1 = GDPgtm1_qoq - GDPtargettm1_qoq;
regtblHPF = table(M2gAtm1_qoq, CPIgtm1_qoq, logGDPgapTargetedtm1, M2gAt_qoq, 'VariableNames',{'LaggedM2g','CPIg','GDPgapTAR','M2g'});
MPgapHPF_results = fitlm(regtblHPF,'M2g~LaggedM2g+CPIg+GDPgapTAR')


%------------------------- Lagged MLE procedure for lagged pi and y -------------------------
%=== xhat: 1: gamma0; 2: gammam; 3: gammapi; 4: gammaxa; 5: gammaxb; 6: sigmaa; 7: sigmab;
n0 = 7; 
%x0 = 5*rand(n0,1); 
x0 = [0.019338,  0.42412, -0.50103,  0.22201,  -1.3022, 0.0070162, 0.03]';
inpdatastr.nSample           = nSample         ;
inpdatastr.M2gAt_qoq         = M2gAt_qoq       ;
inpdatastr.M2gAtm1_qoq       = M2gAtm1_qoq     ;
inpdatastr.CPIgtm1_qoq       = CPIgtm1_qoq     ;
inpdatastr.GDPgtm1_qoq       = GDPgtm1_qoq     ;
inpdatastr.GDPtargettm1_qoq  = GDPtargettm1_qoq;
%-
H0 = 6.0*eye(sum(n0)); %6* works best.
crit = 1.0e-8;
nit = 10000;
%
tic;
if (1)  %Analytical gradient
   [fhat,xhat,grad,Hhat,itct,fcount,retcodehat] = ...
         csminwel('ftd_minuslogLH_mprule_tv',x0,H0,'ftd_minuslogLH_mprule_tv_grad',crit,nit,inpdatastr);         
else  %Numerical gradient
   [fhat,xhat,grad,Hhat,itct,fcount,retcodehat] = ...
         csminwel('ftd_minuslogLH_mprule_tv',x0,H0,'',crit,nit,inpdatastr);         
end            
csmiwel_computingtime = toc
disp(' ');
disp('********************* lagged USED: time-varying MLE with lagged M2, lagged pi and y, GDP log level SA *********************');
disp('------ Printing the minimization results -------');
fhat
grad
itct
fcount
retcodehat
xhat
disp('---- Analytical gradient:');
grad = ftd_minuslogLH_mprule_tv_grad1(xhat, inpdatastr)
%
grdstpsize = 1.0e-5;
hess = fn_hesscd('ftd_minuslogLH_mprule_tv',xhat,grdstpsize,inpdatastr);
hessg = gradcd('ftd_minuslogLH_mprule_tv_grad1',xhat,grdstpsize,inpdatastr);
disp('-------------------- Estimated standard deviations [hess, grad over grad] ---------------------');
disp('-------------------- The second column is supposed to be more accurate ---------------------');
[sqrt(diag(inv(hess))), sqrt(diag(inv(hessg)))]

%=== Computing R squared.
yfitvals      = zeros(nSample,1);
yfitpioutput  = zeros(nSample,1);  %fit to inflation and output.
yfitoutput    = zeros(nSample,1);  %fit to output only.
for (ti=1:nSample)
   GDPgGaptm1 = GDPgtm1_qoq(ti)-GDPtargettm1_qoq(ti);
   if (GDPgGaptm1 >= 0.0)  %Normal regime
      yfitvals(ti)     = xhat(1) + xhat(2)*M2gAtm1_qoq(ti) + xhat(3)*CPIgtm1_qoq(ti) + xhat(4)*GDPgGaptm1;
      yfitpioutput(ti) = xhat(1) + xhat(3)*CPIgtm1_qoq(ti) + xhat(4)*GDPgGaptm1;
      yfitoutput(ti)   = xhat(1) + xhat(4)*GDPgGaptm1;            
   else %Shortfall regime
      yfitvals(ti)     = xhat(1) + xhat(2)*M2gAtm1_qoq(ti) + xhat(3)*CPIgtm1_qoq(ti) + xhat(5)*GDPgGaptm1;
      yfitpioutput(ti) = xhat(1) + xhat(3)*CPIgtm1_qoq(ti) + xhat(5)*GDPgGaptm1; 
      yfitoutput(ti)   = xhat(1) + xhat(5)*GDPgGaptm1;           
   end
end
ms_tvmle = M2gAt_qoq - yfitvals; 
SSreg = sum(ms_tvmle.^2);
SStot = sum((M2gAt_qoq-mean(M2gAt_qoq)).^2);
dfreg = nSample-5;
dftot = nSample-1;
disp('----------- Rsquared and Adjusted Rsquared: -----------');
Rsqured = 1-SSreg/SStot
adjRsqured = 1-(SSreg/dfreg)/(SStot/dftot)




nData = (yrFin-yrBin)*q_m + (qmFin-qmBin+1); % total number of the available data -- this is all you have
qmdates4data = ((yrBin+(qmBin-1)/q_m):1/q_m:(yrFin+(qmFin-1)/q_m))';  % quarterly or monthly dates for the sample (including lags)
nSample = (yrEnd-yrStart)*q_m + (qmEnd-qmStart+1);  % sample length (including lags)
qmdates4sample = ((yrStart+(qmStart-1)/q_m):1/q_m:(yrEnd+(qmEnd-1)/q_m))';  % quarterly or monthly dates for the sample (including lags)
nStart=(yrStart-yrBin)*q_m+qmStart-qmBin;  % positive number of months at the start
nEnd=(yrEnd-yrFin)*q_m+qmEnd-qmFin;     % negative number of months towards end
if ((nEnd>0) | (nStart<0))
   error('The specified sample is out of the bounds of the data!');
end


%************************* Print results for the paper *************************
%======= Estimated original monetary policy shocks.
figure;
bar(qmdates4sample, ms_tvmle); %, '-bd','LineWidth',0.4));
title('Monetary policy shocks (quarterly growth in decimal)');
print -depsc2 outfig_original_mpshocks.eps;
print -dpdf   outfig_original_mpshocks.pdf;

%---------- Converting quarterly cbanges it to yoy changes. --------------
mpshocks7data = NaN*ones(nData,3); 
mpshocks7data((nStart+1):(nData+nEnd),1) = ms_tvmle;    %policy shocks: qoq changes;
mpshocks7data((nStart+1):(nData+nEnd),2) = yfitvals;    %policy systematic response.
mpshocks7data((nStart+1):(nData+nEnd),3) = M2gAt_qoq;   %data: Delta log M2_{t};
loc_mpshock    = 1; %1st column in mpshocks7data. 
loc_mpsys      = 2; %2nd column in mpshocks7data. 
loc_mpact      = 3; %3rd column in mpshocks7data. 
ncum = 4; %Cumulating 4 quarters (periods).
mpshocks_yoylog    = NaN*ones(nData,1);
mpact_yoylog       = NaN*ones(nData,1);
mpsys_yoylog       = NaN*ones(nData,1);
for (ti=ncum:nData)
   cumterm_shock    = mpshocks7data(ti,loc_mpshock);
   cumterm_act      = mpshocks7data(ti,loc_mpact);
   cumterm_sys      = mpshocks7data(ti,loc_mpsys);      
   for (ki=1:(ncum-1))
      cumterm_shock    = cumterm_shock + mpshocks7data((ti-ki),loc_mpshock);
      cumterm_act      = cumterm_act + mpshocks7data((ti-ki),loc_mpact);
      cumterm_sys      = cumterm_sys + mpshocks7data((ti-ki),loc_mpsys);            
   end
   mpshocks_yoylog(ti)   = cumterm_shock;
   mpact_yoylog(ti)      = cumterm_act;
   mpsys_yoylog(ti)      = cumterm_sys;
end
m.fig = figure('PaperPosition',[0.25 1 8 11]); %[left bottom witdh height]  Tip: bottom + height = 10.0
subplot(2,1,1);
plot(qmdates4sample, mpact_yoylog(nStart+1:nData+nEnd)*100,'--xk','linewidth',0.7);
hold on;
plot(qmdates4sample, mpsys_yoylog(nStart+1:nData+nEnd)*100,'-b','linewidth',1.0);
% set(get(AX,'Ylabel'),'String','Benchmark Borrowing Rate','Color','r') 
% set(AX,'YColor','k')
% set(H1,'LineStyle','-','Color','k','LineWidth',1.3)
hold off;
xlim([2000 2017]);
%xticks([2001 2003 2005 2007 2009 2011 2013 2015]);
grid;
ylabel('Year over year change (%)');
legend('Data','Endogenous');
box on;
subplot(2,1,2);
plot(qmdates4sample, mpshocks_yoylog(nStart+1:nData+nEnd)*100,'-k','linewidth',1.8);
hold on;
plot(qmdates4sample,zeros(nSample,1),':k','linewidth',0.2);
hold off;
xlim([2000 2017]);
%xticks([2001 2003 2005 2007 2009 2011 2013 2015]);
grid;
ylim([-5, 5]);
ylabel('Year over year change (%)');
legend('Exogenous');
box on;
print -depsc2 outfig_MP_yoy.eps;
print -dpdf   outfig_MP_yoy.pdf;

%======= GDP and inflation
logGDPgap = logGDPt - GDPloglevelTarget;
logGDPgapSample = logGDPgap((nStart+1):(nData+nEnd));
locs_LessTarget = (logGDPgapSample <= 0.00001);
CPIgyoyt = logCPIt - logCPItm4;       %y/y CPI inflation at t.
CPIgyoytSample = CPIgyoyt((nStart+1):(nData+nEnd));
%-
m.fig = figure('PaperPosition',[0.25 1 6 6]); %[left bottom witdh height]  Tip: bottom + height = 10.0
subplot(2,1,1);
plot(qmdates4sample, logGDPgapSample*100,'-b','LineWidth',1.5);
hold on;
bar(qmdates4sample(locs_LessTarget), logGDPgapSample(locs_LessTarget)*100, 0.7, 'FaceColor',[0.5 .75 .75]);
plot(qmdates4sample, zeros(nSample,1), '-k','LineWidth',0.1);
hold off;
ylabel('GDP growth less target (yoy %)');
xlim([2000 2017]);
grid;
subplot(2,1,2);
plot(qmdates4sample, CPIgyoytSample*100,'LineStyle','-','LineWidth',1.5,'Color',[1.0 0.4 0.2]);
hold on;
plot(qmdates4sample, zeros(nSample,1), '-k','LineWidth',0.1);
hold off;
ylabel('CPI inflation (yoy %)');
xlim([2000 2017]);
grid;
print -depsc2 outfigpaper_data_GDPCPI_annual.eps;
print -dpdf   outfigpaper_data_GDPCPI_annual.pdf;
